<?php
// Script para hacer backup del SP actual y crear uno corregido
require_once "model/model_conexion.php";

echo "<h2>Backup y corrección de SP_LISTAR_TRAMITE_AREA</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    // Obtener la definición actual
    echo "<h3>1. Procedimiento actual (que acabas de ejecutar - INCORRECTO):</h3>";
    $query = $pdo->prepare("SHOW CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA");
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        $currentSP = $result['Create Procedure'];
        echo "<pre style='background: #fff0f0; padding: 10px; border-left: 3px solid #f00;'>";
        echo htmlspecialchars($currentSP);
        echo "</pre>";

        // Guardar en archivo
        file_put_contents('backup_sp_incorrecto.sql', $currentSP);
        echo "<p style='color: green;'>✓ Backup guardado en: backup_sp_incorrecto.sql</p>";
    }

    echo "<hr>";

    // Necesito buscar un SP de respaldo o uno similar
    echo "<h3>2. Buscando procedimientos similares para referencia:</h3>";

    $procedures = ['SP_LISTAR_TRAMITE_AREA_FINALIZADO', 'SP_LISTAR_TRAMITE_AREA_ENVIADO', 'SP_LISTAR_TRAMITE'];

    foreach ($procedures as $procName) {
        try {
            $q = $pdo->prepare("SHOW CREATE PROCEDURE $procName");
            $q->execute();
            $r = $q->fetch(PDO::FETCH_ASSOC);

            if ($r) {
                echo "<h4>Procedimiento: $procName</h4>";
                echo "<pre style='background: #f0fff0; padding: 10px; border-left: 3px solid #0a0;'>";
                echo htmlspecialchars($r['Create Procedure']);
                echo "</pre>";
            }
        } catch (Exception $e) {
            echo "<p style='color: #999;'>$procName no existe</p>";
        }
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3, h4 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
</style>
