CREATE DEFINER=`root`@`localhost` PROCEDURE `SP_LISTAR_TRAMITE_AREA`(
    IN IDUSUARIO INT,
    IN TIPO_RE VARCHAR(20)
)
BEGIN
    -- Este SP lista los trámites que están PENDIENTES en el área del usuario
    -- NO debe mostrar los que ya fueron derivados o finalizados desde esa área

    SELECT
        m.movimiento_id,
        m.documento_id,
        d.doc_dni,
        d.doc_nom,
        d.doc_ape,
        tipo.tipo_tramite AS asunto,
        d.doc_representacion,
        m.mov_archivo,
        m.mov_descripcion,
        m.mov_fecharegistro,
        m.mov_estatus,
        area_origen.area_nombre AS area_origen,
        area_destino.area_nombre AS area_destino,
        m.area_origen_id,
        m.area_destino_id,
        d.doc_folio
    FROM movimiento m
    INNER JOIN documento d ON m.documento_id = d.documento_id
    INNER JOIN tipo_tramite tipo ON d.tipo_tramite_id = tipo.tipo_tramite_id
    LEFT JOIN area AS area_origen ON m.area_origen_id = area_origen.area_cod
    LEFT JOIN area AS area_destino ON m.area_destino_id = area_destino.area_cod
    INNER JOIN usuario u ON u.usuario_id = IDUSUARIO
    WHERE
        -- El área destino del movimiento es el área del usuario
        m.area_destino_id = u.area_cod
        -- Y el estado del movimiento es PENDIENTE (no ha sido procesado aún)
        AND m.mov_estatus = 'PENDIENTE'
        -- Asegurar que el documento no está finalizado globalmente
        AND d.doc_estatus != 'FINALIZADO'
        -- Solo mostrar documentos del año actual o filtro específico
        AND (TIPO_RE = '' OR d.doc_representacion = TIPO_RE)
    ORDER BY m.mov_fecharegistro DESC;
END