-- ========================================
-- ACTUALIZAR SOLO LOS STORED PROCEDURES
-- ========================================
-- El campo mov_recibido ya existe, solo actualizamos los SP

-- Actualizar datos existentes por si acaso
UPDATE movimiento SET mov_recibido = 0
WHERE (mov_estatus = 'PENDIENTE' OR mov_estatus = '' OR mov_estatus IS NULL)
AND mov_recibido != 0;

UPDATE movimiento SET mov_recibido = 1
WHERE mov_estatus IN ('DERIVADO', 'FINALIZADO')
AND mov_recibido != 1;

SELECT '✅ Datos actualizados' AS Resultado;

-- ========================================
-- SP_REGISTRAR_TRAMITE_DERIVAR
-- ========================================

DROP PROCEDURE IF EXISTS SP_REGISTRAR_TRAMITE_DERIVAR;

DELIMITER $$

CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR(
    IN IDDO VARCHAR(50),
    IN ORIG INT,
    IN DEST INT,
    IN DESCRIP VARCHAR(255),
    IN IDUSU INT,
    IN RUTA VARCHAR(255),
    IN ACCION VARCHAR(20),
    IN VISIBLE_PUBLICO TINYINT
)
BEGIN
    -- PASO 1: Actualizar movimiento anterior de PENDIENTE a DERIVADO
    UPDATE movimiento
    SET
        mov_estatus = 'DERIVADO',
        mov_recibido = 1
    WHERE documento_id = IDDO
    AND area_destino_id = ORIG
    AND mov_estatus = 'PENDIENTE'
    AND mov_recibido = 0
    ORDER BY movimiento_id DESC
    LIMIT 1;

    -- PASO 2: Insertar nuevo movimiento
    IF ACCION = 'DERIVAR' THEN
        INSERT INTO movimiento(
            documento_id,
            area_origen_id,
            area_destino_id,
            mov_descripcion,
            mov_estatus,
            mov_fecharegistro,
            usuario_id,
            mov_archivo,
            mov_visible_publico,
            mov_recibido
        ) VALUES (
            IDDO,
            ORIG,
            DEST,
            DESCRIP,
            'PENDIENTE',
            NOW(),
            IDUSU,
            RUTA,
            VISIBLE_PUBLICO,
            0
        );
    ELSE
        INSERT INTO movimiento(
            documento_id,
            area_origen_id,
            area_destino_id,
            mov_descripcion,
            mov_estatus,
            mov_fecharegistro,
            usuario_id,
            mov_archivo,
            mov_visible_publico,
            mov_recibido
        ) VALUES (
            IDDO,
            ORIG,
            NULL,
            DESCRIP,
            'FINALIZADO',
            NOW(),
            IDUSU,
            RUTA,
            VISIBLE_PUBLICO,
            1
        );

        UPDATE documento SET doc_estatus = 'FINALIZADO' WHERE documento_id = IDDO;
    END IF;
END$$

DELIMITER ;

SELECT '✅ SP_REGISTRAR_TRAMITE_DERIVAR actualizado' AS Resultado;

-- ========================================
-- SP_LISTAR_TRAMITE_AREA (Trámites Recibidos)
-- ========================================

DROP PROCEDURE IF EXISTS SP_LISTAR_TRAMITE_AREA;

DELIMITER $$

CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA(
    IN IDUSUARIO INT,
    IN TIPO_RE VARCHAR(20)
)
BEGIN
    DECLARE IDAREA INT;
    SET @IDAREA := (SELECT area_id FROM usuario WHERE usu_id = IDUSUARIO);

    SELECT
        SUBSTRING_INDEX(documento.documento_id, '-', 1) AS expe_num,
        documento.documento_id,
        documento.doc_nrodocumento,
        documento.doc_dniremitente,
        documento.doc_nombreremitente,
        documento.doc_apepatremitente,
        documento.doc_apematremitente,
        documento.doc_emailremitente,
        documento.doc_celularremitente,
        documento.doc_direccionremitente,
        documento.doc_representacion,
        documento.doc_ruc,
        documento.doc_empresa,
        documento.doc_folio,
        documento.doc_archivo,
        documento.doc_asunto,
        documento.doc_fecharegistro,
        documento.tipodocumento_id,
        documento.area_origen,
        documento.area_destino,
        documento.doc_estatus,
        tipo_documento.tipodocumento_id AS tipodoc_id,
        tipo_documento.tipodoc_descripcion,
        tupa.tupa_id,
        tupa.tupa_descripcion,
        tupa.tupa_requisitos,
        movimiento.movimiento_id,
        movimiento.area_origen_id,
        movimiento.area_destino_id,
        movimiento.mov_estatus,
        movimiento.mov_descripcion,
        movimiento.mov_archivo,
        movimiento.mov_fecharegistro,
        areaorigen.area_nombre AS origen,
        areadestino.area_nombre AS destino,
        documento.grupo_area_destino_id,
        grupo.area_nombre AS grupo,
        CONCAT_WS(' ',
            documento.doc_nombreremitente,
            documento.doc_apepatremitente,
            documento.doc_apematremitente
        ) AS REMITENTE
    FROM movimiento
    INNER JOIN documento ON movimiento.documento_id = documento.documento_id
    LEFT JOIN tipo_documento ON documento.tipodocumento_id = tipo_documento.tipodocumento_id
    LEFT JOIN tupa ON documento.tupa_id = tupa.tupa_id
    LEFT JOIN area AS areaorigen ON movimiento.area_origen_id = areaorigen.area_cod
    LEFT JOIN area AS areadestino ON movimiento.area_destino_id = areadestino.area_cod
    LEFT JOIN area AS grupo ON documento.grupo_area_destino_id = grupo.area_cod
    WHERE
        movimiento.area_destino_id = @IDAREA
        AND movimiento.mov_estatus = 'PENDIENTE'
        AND movimiento.mov_recibido = 0
        AND movimiento.movimiento_id = (
            SELECT MAX(m2.movimiento_id)
            FROM movimiento m2
            WHERE m2.documento_id = movimiento.documento_id
            AND m2.area_destino_id = @IDAREA
            AND m2.mov_estatus = 'PENDIENTE'
            AND m2.mov_recibido = 0
        )
        AND (TIPO_RE = '' OR documento.doc_representacion = TIPO_RE)
    ORDER BY movimiento.mov_fecharegistro DESC;
END$$

DELIMITER ;

SELECT '✅ SP_LISTAR_TRAMITE_AREA actualizado' AS Resultado;

-- ========================================
-- SP_LISTAR_TRAMITE_AREA_DERIVADO (Trámites Derivados)
-- ========================================

DROP PROCEDURE IF EXISTS SP_LISTAR_TRAMITE_AREA_DERIVADO;

DELIMITER $$

CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA_DERIVADO(
    IN IDUSUARIO INT
)
BEGIN
    DECLARE IDAREA INT;
    SET @IDAREA := (SELECT area_id FROM usuario WHERE usu_id = IDUSUARIO);

    SELECT
        SUBSTRING_INDEX(documento.documento_id, '-', 1) AS expe_num,
        documento.documento_id,
        documento.doc_nrodocumento,
        documento.doc_dniremitente,
        documento.doc_nombreremitente,
        documento.doc_apepatremitente,
        documento.doc_apematremitente,
        documento.doc_emailremitente,
        documento.doc_celularremitente,
        documento.doc_direccionremitente,
        documento.doc_representacion,
        documento.doc_ruc,
        documento.doc_empresa,
        documento.doc_folio,
        documento.doc_archivo,
        documento.doc_asunto,
        documento.doc_fecharegistro,
        documento.tipodocumento_id,
        documento.area_origen,
        documento.area_destino,
        documento.doc_estatus,
        tipo_documento.tipodocumento_id AS tipodoc_id,
        tipo_documento.tipodoc_descripcion,
        tupa.tupa_id,
        tupa.tupa_descripcion,
        tupa.tupa_requisitos,
        movimiento.movimiento_id,
        movimiento.area_origen_id,
        movimiento.area_destino_id,
        movimiento.mov_estatus,
        movimiento.mov_descripcion,
        movimiento.mov_archivo,
        movimiento.mov_fecharegistro,
        areaorigen.area_nombre AS origen,
        areadestino.area_nombre AS destino,
        documento.grupo_area_destino_id,
        grupo.area_nombre AS grupo,
        CONCAT_WS(' ',
            documento.doc_nombreremitente,
            documento.doc_apepatremitente,
            documento.doc_apematremitente
        ) AS REMITENTE
    FROM movimiento
    INNER JOIN documento ON movimiento.documento_id = documento.documento_id
    LEFT JOIN tipo_documento ON documento.tipodocumento_id = tipo_documento.tipodocumento_id
    LEFT JOIN tupa ON documento.tupa_id = tupa.tupa_id
    LEFT JOIN area AS areaorigen ON movimiento.area_origen_id = areaorigen.area_cod
    LEFT JOIN area AS areadestino ON movimiento.area_destino_id = areadestino.area_cod
    LEFT JOIN area AS grupo ON documento.grupo_area_destino_id = grupo.area_cod
    WHERE
        movimiento.area_destino_id = @IDAREA
        AND movimiento.mov_estatus = 'DERIVADO'
        AND movimiento.mov_recibido = 1
    ORDER BY movimiento.mov_fecharegistro DESC;
END$$

DELIMITER ;

SELECT '✅ SP_LISTAR_TRAMITE_AREA_DERIVADO actualizado' AS Resultado;
SELECT '✅ ¡TODO LISTO!' AS Resultado;
SELECT 'Limpia las tablas y prueba el flujo completo' AS Instruccion;
