-- ========================================
-- SP CON DEBUG PARA VER QUÉ ESTÁ PASANDO
-- ========================================

DROP PROCEDURE IF EXISTS SP_REGISTRAR_TRAMITE_DERIVAR;

DELIMITER $$

CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR(
    IN IDDO VARCHAR(50),
    IN ORIG INT,
    IN DEST INT,
    IN DESCRIP VARCHAR(255),
    IN IDUSU INT,
    IN RUTA VARCHAR(255),
    IN ACCION VARCHAR(20),
    IN VISIBLE_PUBLICO TINYINT
)
BEGIN
    DECLARE filas_afectadas INT DEFAULT 0;

    -- PASO 1: Actualizar movimiento anterior de PENDIENTE a DERIVADO
    UPDATE movimiento
    SET
        mov_estatus = 'DERIVADO',
        mov_recibido = 1
    WHERE documento_id = IDDO
    AND area_destino_id = ORIG
    AND mov_estatus = 'PENDIENTE'
    AND mov_recibido = 0
    ORDER BY movimiento_id DESC
    LIMIT 1;

    -- Obtener cuántas filas se actualizaron
    SET filas_afectadas = ROW_COUNT();

    -- Insertar log en una tabla temporal (crear tabla si no existe)
    CREATE TABLE IF NOT EXISTS debug_sp_log (
        log_id INT AUTO_INCREMENT PRIMARY KEY,
        log_fecha DATETIME,
        log_mensaje VARCHAR(500)
    );

    INSERT INTO debug_sp_log (log_fecha, log_mensaje)
    VALUES (NOW(), CONCAT('UPDATE afectó ', filas_afectadas, ' filas. IDDO=', IDDO, ', ORIG=', ORIG, ', ACCION=', ACCION));

    -- PASO 2: Insertar nuevo movimiento
    IF ACCION = 'DERIVAR' THEN
        INSERT INTO movimiento(
            documento_id,
            area_origen_id,
            area_destino_id,
            mov_descripcion,
            mov_estatus,
            mov_fecharegistro,
            usuario_id,
            mov_archivo,
            mov_visible_publico,
            mov_recibido
        ) VALUES (
            IDDO,
            ORIG,
            DEST,
            DESCRIP,
            'PENDIENTE',
            NOW(),
            IDUSU,
            RUTA,
            VISIBLE_PUBLICO,
            0
        );
    ELSE
        INSERT INTO movimiento(
            documento_id,
            area_origen_id,
            area_destino_id,
            mov_descripcion,
            mov_estatus,
            mov_fecharegistro,
            usuario_id,
            mov_archivo,
            mov_visible_publico,
            mov_recibido
        ) VALUES (
            IDDO,
            ORIG,
            NULL,
            DESCRIP,
            'FINALIZADO',
            NOW(),
            IDUSU,
            RUTA,
            VISIBLE_PUBLICO,
            1
        );

        UPDATE documento SET doc_estatus = 'FINALIZADO' WHERE documento_id = IDDO;
    END IF;
END$$

DELIMITER ;

SELECT '✅ SP_REGISTRAR_TRAMITE_DERIVAR con DEBUG actualizado' AS Resultado;
